/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.Port;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class PortBridge
extends Port {
    protected String macAddressString;
    protected String ipAddress;

    public PortBridge(String string) {
        this.ipAddress = string;
    }

    public void setSpecificInformation() {
        super.setSpecificInformation();
        this.hub.askMACAddress(this);
    }

    public boolean findMACAddress() {
        String string = "findMACAddress";
        try {
            if (this.ipAddress == null) {
                throw new IllegalArgumentException("Invalid IP address for bridge port " + this.ipAddress);
            }
            if (!this.ipAddress.equals("0.0.0.0")) {
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.BridgeIp", new IPAddress(this.ipAddress));
                modelInfo.add("Index.PortNumber", new Integer(this.portNumber));
                GenModel genModel = (GenModel)this.hub.getBrowser().getModel();
                GenModel genModel2 = (GenModel)genModel.getComponent("BridgeSwitcher");
                GenModel genModel3 = genModel2.getRowRef(modelInfo);
                GenModel genModel4 = (GenModel)genModel3.getComponent("PortMac");
                ModelInfo modelInfo2 = genModel4.getInfo("PortMac", "default", modelInfo);
                Serializable serializable = modelInfo2.get("PortMac.PortPhysicalAddress");
                if (serializable instanceof OctetString) {
                    this.macAddressString = serializable.toString().toUpperCase();
                    return true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RAS.logException(19, 2, this, string, (Exception)illegalArgumentException);
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        this.macAddressString = null;
        return false;
    }

    public I18NMsgFormat getFlyOverText() {
        String string = "getFlyOverText";
        if (this.macAddressString == null) {
            return super.getFlyOverText();
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(this.portNumber);
        String string2 = "Port_unspecified_conn";
        try {
            string2 = Port.PORT_TYPE[this.portType];
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Cannot find fly-over for port type -> " + this.portType);
            }
            RAS.logException(19, 2, this, string, exception);
        }
        objectArray[1] = this.hub.getBundle().getString(string2);
        objectArray[2] = this.macAddressString;
        return new I18NMsgFormat("ibm.nways.jdm8260.DeviceView.GraphicResources", "PortWithMac", objectArray);
    }
}

